<?php

namespace App\Http\Controllers;

use App\Models\Hadiah;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

use Illuminate\Support\Facades\Route;
use Intervention\Image\Laravel\Facades\Image;

class HadiahController extends Controller
{
    public function index()
    {
        $hadiah = Hadiah::pencarian()->latest()->paginate(10);
        $data = [
            'title' => 'Ramizah Store | Hadiah Poin',
            'page' => 'Hadiah Poin',
            'menuActive' => 'hadiah',
            'menuOpen' => 'hadiah',
        ];
        return view('admin.hadiah.hadiah_poin', compact('data', 'hadiah'))->with('no', 1);
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'kd_hadiah' => 'required|unique:hadiahs,kd_hadiah',
                'nm_hadiah' => 'required',
                'stok' => 'required',
                'poin' => 'required',
                'keterangan' => 'required',
                'gambar'   => 'image|mimes:jpeg,jpg,png|max:2048',

            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Kode Item sudah pernah diinputkan, silahkan input Kode  lain!',
            ]
        );

        if ($request->hasFile('gambar')) {
            $upload = $request->file('gambar');
            $image = Image::read($upload)->resize(600, 600);
            Storage::put(
                'public/produk/' . $upload->hashName(),
                $image->encodeByExtension($upload->getClientOriginalExtension(), quality: 85)
            );
            $isi = $upload->hashName();
        } else {
            $isi = '';
        }

        Hadiah::create([
            'kd_hadiah' => $request->kd_hadiah,
            'nm_hadiah' => $request->nm_hadiah,
            'stok' => $request->stok,
            'poin' => $request->poin,
            'gambar' =>  $isi,
            'keterangan' => $request->keterangan,
            'link_hadiah'   => strtolower($request->kd_hadiah) . '-' . Str::slug($request->nm_hadiah),
        ]);

        return redirect()->route('hadiah-point.index')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function update(Request $request)
    {
        $id = $request->id;

        $gbrlama = $request->gbrlama;

        if ($request->kdlama != $request->kd_hadiah) {
            $rule = 'required|unique:hadiahs,kd_hadiah';
        } else {
            $rule = 'required';
        }

        $request->validate(
            [
                'kd_hadiah' =>  $rule,
                'nm_hadiah' => 'required',
                'stok' => 'required',
                'poin' => 'required',
                'keterangan' => 'required',
                'gambar'   => 'image|mimes:jpeg,jpg,png|max:2048',

            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Kode Item sudah pernah diinputkan, silahkan input Kode  lain!',
            ]
        );

        $hadiah = Hadiah::findOrFail($id);
        if ($request->hasFile('gambar')) {
            // //upload image
            if ($gbrlama != null) {
                Storage::delete('public/produk/' .  $gbrlama);
            }
            $upload = $request->file('gambar');
            $image = Image::read($upload)->resize(600, 600);
            Storage::put(
                'public/produk/' . $upload->hashName(),
                $image->encodeByExtension($upload->getClientOriginalExtension(), quality: 85)
            );
            $hadiah->update([
                'gambar'             =>  $upload->hashName(),
            ]);
        }

        $hadiah->update([
            'kd_hadiah' => $request->kd_hadiah,
            'nm_hadiah' => $request->nm_hadiah,
            'stok' => $request->stok,
            'poin' => $request->poin,
            'keterangan' => $request->keterangan,
            'link_hadiah'   => strtolower($request->kd_hadiah) . '-' . Str::slug($request->nm_hadiah),
        ]);

        return redirect()->route('hadiah-point.index')->with(['success' => 'Edit Data Berhasil Disimpan!']);
    }

    public function destroy($id)
    {
        $img = Hadiah::where('id', $id)->first();
        if ($img->gambar != null) {
            Storage::delete('public/produk/' .  $img->gambar);
            Hadiah::findOrFail($id)->delete();
        }
        return redirect()->route('hadiah-point.index')->with(['success' => 'Data Berhasil Dihapus!']);
    }

    public function destroy_all_hadiah(Request $request)
    {
        $ids = $request->allVals;
        foreach ($ids as  $id) {
            $img = Hadiah::where('id', $id)->first();
            if ($img->gambar != null) {
                Storage::delete('public/produk/' .  $img->gambar);
            }
            Hadiah::where('id', $id)->delete();
        }

        return response()->json($ids);
    }
}
